import React from "react";
import type { FrameSnapshot } from "../types";

type FrameCardProps = {
  frame: FrameSnapshot;
  index: number;
  onDownload: (frame: FrameSnapshot) => void;
  formattedTime: string;
};

const FrameCard: React.FC<FrameCardProps> = ({
  frame,
  index,
  onDownload,
  formattedTime,
}) => {
  return (
    <div className="flex flex-col overflow-hidden rounded-xl border border-slate-200 bg-white shadow-sm">
      <div className="relative">
        <img
          src={frame.dataUrl}
          alt={`Кадр ${index + 1}`}
          className="h-36 w-full object-cover"
          loading="lazy"
        />
        <span className="absolute left-2 top-2 rounded-full bg-black/70 px-2 py-0.5 text-xs font-semibold text-white">
          {formattedTime}
        </span>
      </div>
      <div className="flex items-center justify-between px-3 py-2 text-xs text-slate-600">
        <span>Кадр {index + 1}</span>
        <button
          type="button"
          onClick={() => onDownload(frame)}
          className="text-slate-900 hover:text-slate-700"
        >
          Скачать
        </button>
      </div>
    </div>
  );
};

export default FrameCard;
