import React from "react";

type StoryboardControlsProps = {
  stepSeconds: number;
  onStepChange: (value: number) => void;
  onGenerate: () => void;
  disabled?: boolean;
  isLoading?: boolean;
};

const StoryboardControls: React.FC<StoryboardControlsProps> = ({
  stepSeconds,
  onStepChange,
  onGenerate,
  disabled,
  isLoading,
}) => {
  return (
    <section className="rounded-2xl border border-slate-200 bg-white p-6 shadow-sm">
      <div className="flex flex-col gap-4 md:flex-row md:items-end md:justify-between">
        <div className="flex flex-col gap-2">
          <h2 className="text-lg font-semibold text-slate-900">Шаг кадров</h2>
          <p className="text-sm text-slate-600">
            Укажите, как часто извлекать кадры. Обычно 1–2 секунды дают хорошую
            детализацию.
          </p>
          <label className="text-sm font-medium text-slate-700">
            <span className="mb-1 block">Интервал (сек.)</span>
            <input
              type="number"
              min={0.2}
              step={0.2}
              value={stepSeconds}
              disabled={disabled || isLoading}
              onChange={(event) => onStepChange(Number(event.target.value))}
              className="w-40 rounded-lg border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700 focus:border-slate-400 focus:outline-none"
            />
          </label>
        </div>
        <button
          type="button"
          onClick={onGenerate}
          disabled={disabled || isLoading}
          className="inline-flex items-center justify-center rounded-lg bg-slate-900 px-5 py-2.5 text-sm font-semibold text-white transition hover:bg-slate-800 disabled:cursor-not-allowed disabled:bg-slate-400"
        >
          {isLoading ? "Генерация…" : "Пересобрать раскадровку"}
        </button>
      </div>
    </section>
  );
};

export default StoryboardControls;
