import React from "react";
import type { FrameSnapshot } from "../types";
import FrameCard from "./FrameCard";

type StoryboardGridProps = {
  frames: FrameSnapshot[];
  onDownload: (frame: FrameSnapshot) => void;
  formatTime: (seconds: number) => string;
};

const StoryboardGrid: React.FC<StoryboardGridProps> = ({
  frames,
  onDownload,
  formatTime,
}) => {
  if (frames.length === 0) {
    return (
      <div className="rounded-2xl border border-dashed border-slate-200 bg-white/70 p-8 text-center text-sm text-slate-500">
        Здесь появится раскадровка после загрузки видео.
      </div>
    );
  }

  return (
    <div className="grid gap-4 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
      {frames.map((frame, index) => (
        <FrameCard
          key={frame.id}
          frame={frame}
          index={index}
          formattedTime={formatTime(frame.time)}
          onDownload={onDownload}
        />
      ))}
    </div>
  );
};

export default StoryboardGrid;
