import React from "react";

type VideoUploaderProps = {
  onFileSelected: (file: File) => void;
  disabled?: boolean;
  helperText?: string;
  error?: string | null;
};

const VideoUploader: React.FC<VideoUploaderProps> = ({
  onFileSelected,
  disabled,
  helperText,
  error,
}) => {
  return (
    <section className="rounded-2xl border border-slate-200 bg-white p-6 shadow-sm">
      <div className="flex flex-col gap-3">
        <div>
          <h2 className="text-lg font-semibold text-slate-900">Загрузка видео</h2>
          <p className="text-sm text-slate-600">
            Поддерживаются MP4 и WebM. Видео обрабатывается полностью в браузере.
          </p>
        </div>
        <label className="flex flex-col gap-2 text-sm font-medium text-slate-700">
          <span>Выберите файл</span>
          <input
            type="file"
            accept="video/mp4,video/webm"
            disabled={disabled}
            onChange={(event) => {
              const file = event.target.files?.[0];
              if (file) {
                onFileSelected(file);
              }
            }}
            className="w-full rounded-lg border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700 file:mr-4 file:rounded-md file:border-0 file:bg-slate-900 file:px-4 file:py-2 file:text-sm file:font-semibold file:text-white hover:file:bg-slate-800"
          />
        </label>
        {helperText && <p className="text-xs text-slate-500">{helperText}</p>}
        {error && (
          <p className="rounded-lg border border-rose-200 bg-rose-50 px-3 py-2 text-xs text-rose-700">
            {error}
          </p>
        )}
      </div>
    </section>
  );
};

export default VideoUploader;
