/**
 * Компонент сетки кадров (раскадровки)
 */

import type { ExtractedFrame } from '../types';
import { FrameCard } from './FrameCard';

interface FrameGridProps {
  frames: ExtractedFrame[];
}

export function FrameGrid({ frames }: FrameGridProps) {
  if (frames.length === 0) {
    return null;
  }

  return (
    <div className="bg-white dark:bg-gray-800 rounded-xl p-4 md:p-6 shadow-md">
      <div className="flex items-center justify-between mb-4">
        <h3 className="text-lg font-semibold text-gray-800 dark:text-white">
          Раскадровка
        </h3>
        <span className="text-sm text-gray-500 dark:text-gray-400">
          {frames.length} кадр{frames.length > 1 && frames.length < 5 ? 'а' : frames.length >= 5 ? 'ов' : ''}
        </span>
      </div>

      <p className="text-sm text-gray-500 dark:text-gray-400 mb-4">
        Наведите на кадр для скачивания. Выберите формат: PNG для качества или JPEG для меньшего размера.
      </p>

      {/* Сетка кадров - адаптивная */}
      <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-3">
        {frames.map((frame, index) => (
          <FrameCard key={frame.id} frame={frame} index={index} />
        ))}
      </div>
    </div>
  );
}
