/**
 * Компонент индикатора прогресса
 */

interface ProgressBarProps {
  progress: number;
  message?: string;
}

export function ProgressBar({ progress, message }: ProgressBarProps) {
  return (
    <div className="bg-white dark:bg-gray-800 rounded-xl p-6 shadow-md">
      <div className="flex items-center justify-between mb-2">
        <span className="text-sm font-medium text-gray-700 dark:text-gray-300">
          {message || 'Обработка видео...'}
        </span>
        <span className="text-sm font-medium text-blue-500">
          {progress}%
        </span>
      </div>
      
      {/* Прогресс-бар */}
      <div className="w-full h-3 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden">
        <div 
          className="h-full bg-gradient-to-r from-blue-500 to-blue-600 rounded-full transition-all duration-300 ease-out"
          style={{ width: `${progress}%` }}
        />
      </div>

      {/* Анимированные точки */}
      <div className="flex justify-center mt-4 gap-1">
        {[0, 1, 2].map((i) => (
          <div
            key={i}
            className="w-2 h-2 bg-blue-500 rounded-full animate-bounce"
            style={{ animationDelay: `${i * 0.15}s` }}
          />
        ))}
      </div>

      <p className="text-center text-xs text-gray-500 dark:text-gray-400 mt-3">
        Пожалуйста, не закрывайте страницу
      </p>
    </div>
  );
}
