/**
 * Типы для Video Storyboard & Frame Extractor
 */

/** Извлечённый кадр из видео */
export interface ExtractedFrame {
  /** Уникальный идентификатор кадра */
  id: string;
  /** Временная метка кадра в секундах */
  timestamp: number;
  /** Data URL изображения (base64) */
  dataUrl: string;
  /** Ширина кадра в пикселях */
  width: number;
  /** Высота кадра в пикселях */
  height: number;
}

/** Информация о загруженном видео */
export interface VideoInfo {
  /** Имя файла */
  name: string;
  /** Размер файла в байтах */
  size: number;
  /** MIME-тип файла */
  type: string;
  /** Длительность видео в секундах */
  duration: number;
  /** Ширина видео в пикселях */
  width: number;
  /** Высота видео в пикселях */
  height: number;
}

/** Состояние загрузки/обработки */
export type ProcessingStatus = 
  | 'idle'           // Ожидание загрузки файла
  | 'loading'        // Загрузка файла
  | 'extracting'     // Извлечение кадров
  | 'complete'       // Обработка завершена
  | 'error';         // Ошибка

/** Формат экспорта изображения */
export type ImageFormat = 'png' | 'jpeg';

/** Ошибка приложения */
export interface AppError {
  /** Код ошибки */
  code: 'UNSUPPORTED_FORMAT' | 'FILE_TOO_LARGE' | 'PROCESSING_ERROR' | 'UNKNOWN';
  /** Сообщение об ошибке */
  message: string;
}

/** Состояние приложения */
export interface AppState {
  /** Информация о видео */
  videoInfo: VideoInfo | null;
  /** Object URL для видео */
  videoUrl: string | null;
  /** Извлечённые кадры */
  frames: ExtractedFrame[];
  /** Шаг извлечения кадров в секундах */
  frameInterval: number;
  /** Статус обработки */
  status: ProcessingStatus;
  /** Прогресс обработки (0-100) */
  progress: number;
  /** Ошибка, если есть */
  error: AppError | null;
}
