/**
 * Компонент ErrorMessage — отображение ошибок пользователю.
 *
 * Показывает сообщение об ошибке с кнопкой закрытия.
 * Используется для:
 * - Ошибок валидации файла (формат, размер)
 * - Ошибок при обработке видео
 */

interface ErrorMessageProps {
  message: string;
  onDismiss: () => void;
}

const ErrorMessage: React.FC<ErrorMessageProps> = ({ message, onDismiss }) => {
  return (
    <div className="bg-red-500/10 border border-red-500/30 rounded-xl p-4 flex items-start gap-3 animate-in">
      {/* Иконка ошибки */}
      <div className="flex-shrink-0 w-8 h-8 rounded-full bg-red-500/20 flex items-center justify-center">
        <svg className="w-4 h-4 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path
            strokeLinecap="round"
            strokeLinejoin="round"
            strokeWidth={2}
            d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
          />
        </svg>
      </div>

      {/* Текст ошибки */}
      <div className="flex-1 min-w-0">
        <p className="text-sm font-medium text-red-300">Ошибка</p>
        <p className="text-sm text-red-400/80 mt-0.5">{message}</p>
      </div>

      {/* Кнопка закрытия */}
      <button
        onClick={onDismiss}
        className="flex-shrink-0 text-red-400/50 hover:text-red-400 transition-colors"
      >
        <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M6 18L18 6M6 6l12 12" />
        </svg>
      </button>
    </div>
  );
};

export default ErrorMessage;
