/**
 * Компонент Header — шапка приложения.
 * Отображает название сервиса и краткое описание.
 */

const Header: React.FC = () => {
  return (
    <header className="border-b border-gray-800 bg-gray-900/80 backdrop-blur-sm sticky top-0 z-50">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 py-4 flex items-center gap-3">
        {/* Иконка — стилизованная кинолента */}
        <div className="flex-shrink-0 w-10 h-10 bg-gradient-to-br from-violet-500 to-indigo-600 rounded-xl flex items-center justify-center shadow-lg shadow-violet-500/20 cursor-pointer" onClick={() => window.location.href = "https://6io.ru"}>
          <svg
            className="w-6 h-6 text-white"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth={2}
              d="M7 4V2m0 2a2 2 0 00-2 2v1a2 2 0 002 2h0a2 2 0 002-2V6a2 2 0 00-2-2zm0 10v-2m0 2a2 2 0 00-2 2v1a2 2 0 002 2h0a2 2 0 002-2v-1a2 2 0 00-2-2zm10-10V2m0 2a2 2 0 00-2 2v1a2 2 0 002 2h0a2 2 0 002-2V6a2 2 0 00-2-2zm0 10v-2m0 2a2 2 0 00-2 2v1a2 2 0 002 2h0a2 2 0 002-2v-1a2 2 0 00-2-2zM5 8h14M5 16h14"
            />
          </svg>
        </div>
        <div>
          <h1 className="text-lg sm:text-xl font-bold text-white tracking-tight">
            Video Storyboard
          </h1>
          <p className="text-xs sm:text-sm text-gray-400">
            Извлечение кадров и создание раскадровки
          </p>
        </div>
      </div>
    </header>
  );
};

export default Header;
