/**
 * Компонент LoadingOverlay — экран загрузки при обработке метаданных видео.
 * Показывается при первоначальной загрузке файла (чтение метаданных).
 */

const LoadingOverlay: React.FC = () => {
  return (
    <div className="flex flex-col items-center justify-center py-12 space-y-4">
      {/* Анимированный спиннер */}
      <div className="relative">
        <div className="w-12 h-12 rounded-full border-2 border-gray-700" />
        <div className="absolute inset-0 w-12 h-12 rounded-full border-2 border-transparent border-t-violet-500 animate-spin" />
      </div>
      <div className="text-center">
        <p className="text-sm font-medium text-gray-300">Загрузка видео…</p>
        <p className="text-xs text-gray-500 mt-1">Чтение метаданных файла</p>
      </div>
    </div>
  );
};

export default LoadingOverlay;
