/** Типы для состояния приложения Video Storyboard & Frame Extractor */

/** Один извлечённый кадр из видео */
export interface ExtractedFrame {
  /** Порядковый номер кадра */
  index: number;
  /** Временная метка кадра в секундах */
  timestamp: number;
  /** Data URL изображения (base64 PNG/JPEG) */
  dataUrl: string;
  /** Ширина кадра в пикселях */
  width: number;
  /** Высота кадра в пикселях */
  height: number;
}

/** Формат скачиваемого изображения */
export type ImageFormat = 'png' | 'jpeg';

/** Информация о загруженном видео */
export interface VideoInfo {
  /** Имя файла */
  name: string;
  /** Размер файла в байтах */
  size: number;
  /** MIME-тип файла */
  type: string;
  /** Длительность видео в секундах */
  duration: number;
  /** Ширина видео в пикселях */
  width: number;
  /** Высота видео в пикселях */
  height: number;
  /** Object URL для воспроизведения */
  objectUrl: string;
}

/** Состояние процесса извлечения кадров */
export type ExtractionStatus =
  | 'idle'        // Ожидание действия пользователя
  | 'loading'     // Загрузка метаданных видео
  | 'extracting'  // Извлечение кадров из видео
  | 'done'        // Извлечение завершено
  | 'error';      // Произошла ошибка

/** Общее состояние приложения */
export interface AppState {
  /** Информация о загруженном видео (null если не загружено) */
  videoInfo: VideoInfo | null;
  /** Массив извлечённых кадров */
  frames: ExtractedFrame[];
  /** Текущий статус обработки */
  status: ExtractionStatus;
  /** Шаг извлечения кадров в секундах */
  stepSeconds: number;
  /** Прогресс извлечения (0–100) */
  progress: number;
  /** Сообщение об ошибке */
  errorMessage: string | null;
}

/** Допустимые MIME-типы видео */
export const SUPPORTED_VIDEO_TYPES = ['video/mp4', 'video/webm'] as const;

/** Максимальный размер файла (500 MB) */
export const MAX_FILE_SIZE = 500 * 1024 * 1024;

/** Варианты шага извлечения кадров */
export const STEP_OPTIONS = [0.5, 1, 2, 3, 5, 10] as const;
